using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using Microsoft.DirectX.Direct3D;
using Microsoft.DirectX;
namespace win
{
    #region main class
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }
        private Device device;
        private  home creating_mesh;
        private float x = 0;
        private float y = 0;
        private user_input direct_input;
        private Vector3 position;
        
        #region initialize device
        private void  initialize_device()
        {
            //loading present parameters
            PresentParameters pp = new PresentParameters();
            pp.BackBufferWidth = 800;
            pp.BackBufferHeight = 600;
            pp.BackBufferFormat = Format.R5G6B5;
            pp.SwapEffect = SwapEffect.Discard;
            pp.Windowed = false;
            pp.AutoDepthStencilFormat = DepthFormat.D16;
            pp.EnableAutoDepthStencil = true;
            //creating device
            device = new Device(0, DeviceType.Hardware, this.Handle, CreateFlags.SoftwareVertexProcessing, pp);
            //creating mesh
            creating_mesh = new home();
            creating_mesh.loading_mesh(device);
            //creating input device
            direct_input = new user_input();
            direct_input.initialize_input_device();
            //set renderstate
            device.RenderState.Lighting = true;
            device.SamplerState[0].MagFilter = TextureFilter.Anisotropic;
            device.SamplerState[0].MinFilter = TextureFilter.Linear;
            device.SamplerState[0].MipFilter = TextureFilter.Linear;
            position = new Vector3(0, 4, 100);
            direct_input.initialize_text(device);
        }
        #endregion

        #region render scene
        private void render()
        {
            device.Clear(ClearFlags.Target|ClearFlags.ZBuffer , Color.DarkGray,1.0f, 0);
            device.BeginScene();
            device.RenderState.Ambient = Color.DarkSlateGray;
            device.Transform.Projection = Matrix.PerspectiveFovLH((float)Math.PI / 4, (float)(this.Width / this.Height), 1f, 500000000f);
            device.Transform.View = Matrix.LookAtLH(new Vector3(0,5,-10) , new Vector3(0,5,0), new Vector3(0, 1, 0));
            //drawing text
            direct_input.draw_text(device,position,x,y);
            //drawing meshs
            creating_mesh.mesh_draw(device,x,y,position);
            device.EndScene();
            device.Present();
        }
        #endregion
        
        #region pint
        void paint(object sender, PaintEventArgs e)
        {
            while (this != null && this.Created)
            {
                render();
                x = direct_input.input_parametersx(x);
                y = direct_input.input_parametersy(y);
                position = direct_input.move(position, device, x, y);
                Application.DoEvents();
            }
        }
        #endregion
        
        #region main function
        static void Main()
        {
           //display form
            Form1 directx_form = new Form1();
            directx_form.initialize_device();
            directx_form.Paint += new PaintEventHandler(directx_form.paint);
            Application.Run(directx_form);
        }
        #endregion
       
        #region exit program
        private void Form1_PreviewKeyDown(object sender, PreviewKeyDownEventArgs e)
        {
            if (e.KeyCode == System.Windows.Forms.Keys.Escape)
            {
                this.Close();
            }
        }
        #endregion
    }
        #endregion
}